import 'product_data.dart';
import 'shop_data.dart';

class StoriesData {
  int? id;
  List<String>? fileUrls;
  ProductData? model;
  String? modelType;
  ShopData? shop;
  DateTime? createdAt;

  StoriesData({
    this.id,
    this.fileUrls,
    this.model,
    this.shop,
    this.modelType,
    this.createdAt,
  });

  StoriesData copyWith({
    int? id,
    List<String>? fileUrls,
    ProductData? model,
    ShopData? shop,
    String? modelType,
  }) => StoriesData(
    id: id ?? this.id,
    fileUrls: fileUrls ?? this.fileUrls,
    model: model ?? this.model,
    shop: shop ?? this.shop,
    modelType: modelType ?? this.modelType,
  );

  factory StoriesData.fromJson(Map<String, dynamic> json) => StoriesData(
    id: json["id"],
    fileUrls: json["file_urls"] == null
        ? []
        : List<String>.from(json["file_urls"]!.map((x) => x)),
    model: json["model"] == null ? null : ProductData.fromJson(json["model"]),
    shop: json["shop"] == null ? null : ShopData.fromJson(json["shop"]),
    modelType: json["model_type"],
    createdAt: DateTime.tryParse(json["created_at"] ?? ''),
  );

  Map<String, dynamic> toJson() => {
    "id": id,
    "model_type": modelType,
    "file_urls": fileUrls == null
        ? []
        : List<dynamic>.from(fileUrls!.map((x) => x)),
    "product": model?.toJson(),
    "shop": shop?.toJson(),
    "created_at": createdAt?.toIso8601String(),
  };
}
